




/**
 ******************************************************************************
 *
 * @file        MG32x02z_ARGB_API.h
 * @brief       Use URT of MG32x02z to control MX25R512F (SPI Flash) standard read / write. 
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.02
 * @date        2022/09/26
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
 
 #ifndef __MG32x02z_URT_ARGB
 #define __MG32x02z_URT_ARGB
 
 #include "MG32x02z.h" 
 #include "MG32x02z_URT.h"
 
/**
 * @name	============== ARGB logic 0 / 1 data proportion ==============
 *   		
 */ 
///@{

//==================================================
//For ARGB WS2812
#define ARGB_LOGIC_URT_0      0xF8            /*!< WS2812 logic 0 data proportion for URT.*/
#define ARGB_LOGIC_URT_1      0xE0            /*!< WS2812 logic 1 data proportion for URT.*/

#define ARGB_LOGIC_SPI_0      0xC0            /*!< WS2812 logic 0 data proportion for SPI.*/
#define ARGB_LOGIC_SPI_1      0xF8            /*!< WS2812 logic 1 data proportion for SPI.*/




/**
 * @name	
 *   		
 */ 
///@{

#define ARGB_DATAPERIPHERAL_MASK           0x0F
#define ARGB_RSTPERIPHERAL_MASK            0xF0


#if defined(URT0_Base)
#define ARGB_DATAPERIPHERAL_URT0           0x00
#endif
#if defined(URT1_Base)
#define ARGB_DATAPERIPHERAL_URT1           0x01
#endif
#if defined(URT2_Base)
#define ARGB_DATAPERIPHERAL_URT2           0x02
#endif
#if defined(URT3_Base)
#define ARGB_DATAPERIPHERAL_URT3           0x03
#endif
#if defined(URT4_Base)
#define ARGB_DATAPERIPHERAL_URT4           0x04
#endif
#if defined(URT5_Base)
#define ARGB_DATAPERIPHERAL_URT5           0x05
#endif
#if defined(URT6_Base)
#define ARGB_DATAPERIPHERAL_URT6           0x06
#endif
#if defined(URT7_Base)
#define ARGB_DATAPERIPHERAL_URT7           0x07
#endif


#if defined(URT0_Base)
#define ARGB_RSTPERIPHERAL_URT0           0x00
#endif
#if defined(URT1_Base)
#define ARGB_RSTPERIPHERAL_URT1           0x10
#endif
#if defined(URT2_Base)
#define ARGB_RSTPERIPHERAL_URT2           0x20
#endif
#if defined(URT3_Base)
#define ARGB_RSTPERIPHERAL_URT3           0x30
#endif





///@}

/**
 * @name	SMP_ARGB_StateTypeDef : ARGB state information
 *   		
 */ 
///@{
#define ARGB_RESET    0x00                 /*!< ARGB handle status is reset.*/
#define ARGB_READY    0x10                 /*!< ARGB handle status is ready.*/
#define ARGB_BUSY     0x11                 /*!< ARGB handle status is busy.*/
#define ARGB_FAIL     0x80                 /*!< ARGB inital fail.*/
///@}

/**
 * @name	SMP_ARGB_TXModeTypeDef : ARGB transmit mode
 *   		
 */ 
///@{

#define ARGB_BLOCKING_MODE              0      /*!< Send data to ARGB  by blocking mode.*/
#define ARGB_IT_MODE                    1      /*!< Send data to ARGB  by interrupt mode.*/

///@}

/**
 * @name	SMP_ARGB_TRGTypeDef : ARGB relationship trigger status.
 *   		
 */ 
///@{

#define ARGB_UPDATE_DATA              0x01     /*!< ARGB data update.*/
#define ARGB_UPDATE_MODE              0x02     /*!< ARGB mode update.*/


///@}

/**
 * @name	SMP_ARGB_DramaModeTypeDef : ARGB Display mode.
 *   		
 */ 
///@{
#define ARGB_DRAMA_DISABLE                0  /*!<ARGB mode = ARGB disable mode.*/
#define ARGB_DRAMA_STATIC                 1  /*!<ARGB mode = ARGB Static color mode.*/
#define ARGB_DRAMA_BREATH                 2  /*!<ARGB mode = ARGB breath mode.*/
#define ARGB_DRAMA_WDROP                  3  /*!<ARGB mode = ARGB water drop mode.*/
#define ARGB_DRAMA_MOVING                 4  /*!<ARGB mode = ARGB signal direct move mode.*/
#define ARGB_DRAMA_2MOVING                5  /*!<ARGB mode = ARGB two direct move mode.*/
///@} 





/*! @struct ARGBCTR_TypeDef
    @brief  
*/ 
typedef struct
{
    //=====================================================================
    //Hardware Control Relationship.
    __IO uint32_t            *ARGB_dREG_INT;       /*< Pointer to control the ARGB interrupt register .*/
                                                   
    __IO uint32_t            *ARGB_dREG_STA;       /*< Pointer to control the ARGB status register .*/
                                  
    __IO uint32_t            *ARGB_rREG_INT;
	
	__IO uint32_t            *ARGB_rREG_STA;
	
    __IO uint32_t            *ARGB_REG_TXData;     /*< Pointer to control the ARGB data transmit register .*/
                                                   
    __IO uint32_t            *ARGB_REG_TMO;        /*< Pointer to control the ARGB timeout timer control register( only for URT) .*/
                                                   
    __IO uint32_t            *ARGB_REG_CRX;        /*< Pointer to control the ARGB control register .*/
                                                   
         uint32_t            ARGB_STA_TX;          /*< Declare TX flag bit.*/
                                                   
         uint32_t            ARGB_STA_TC;          /*< Declare TC flag bit.*/
                                                   
         uint32_t            ARGB_STA_TMO;         /*< Declare TMO flag bit.(only for URT)*/
                                                   
         uint32_t            ARGB_STA_UG;          /*< Declare general event flag bit.(only for URT).*/
                                                   
         uint32_t            ARGB_TMO_EN;          /*< Declare Timeout timer enable bit.(only for URT).*/
                                                   
         IRQn_Type           ARGB_IRQ;             /*< Declare the ARGB IRQ vector.*/
                                                   
         uint8_t             ARGB_LOGIC_0;         /*< Declare the ARGB logical 0 data.*/
                                                   
         uint8_t             ARGB_LOGIC_1;         /*< Declare the ARGB logical 1 data.*/
    //======================================================================
    //Hardware Transmission Relationship.
         uint8_t             DataBitCmp;           /*!< Record transmission bit now. */

         uint8_t             *updateBuf;           /*!< Pointer to data buffer for transmission.*/

         uint32_t            DataCount;            /*!< Record already transmission data bytes.*/
                                                   
    __IO uint32_t            TotalCount;           /*!< Record remaining data bytes.*/
         
         uint8_t             TXData;               /*!< Record transmission data now.*/  
    
         uint8_t             TRES;                 /*!< Control Trst.*/

    __IO uint8_t             State;                /*!< ARGB state information. 
                                                        This parameter can be a value of reference to SMP_ARGB_StateTypeDef*/
                                                                   
    //=======================================================================
    // ARGB mode Drama Control Relationship.
    
         uint8_t             DramaMode;            /*!< ARGB Display mode control.
                                                        This parameter can be a value of reference to SMP_ARGB_DramaModeTypeDef.*/
         uint8_t             UpdateTRG;            /*!< ARGB control relationship trigger parameter.
                                                        This parameter can be any value of SMP_ARGB_TRGTypeDef.*/
                                                     
         uint8_t             DramaTmp[3];          /*!< Calculate Temporary buffer.*/
                                                   
         uint8_t             *DramaBuf;            /*!< Pointer to data buffer for calculation.*/
                                                   
         uint8_t             DramaAct;             /*!< Control the ARGB drama current main step*/
                                                   
         uint8_t             DramaActMax;          /*!< Control the ARGB drama max main step.*/
           
         uint8_t             DramaTime;            /*!< Control the ARGB drama current time .*/
                                                   
         uint8_t             DramaTimeMax;         /*!< Control the ARGB drama max time .*/

         uint32_t            DramaScene;           /*!< Control the ARGB drama current substep*/
                                                   
         uint32_t            DramaSceneMax;        /*!< Control the ARGB drama max substep.*/
                                                   
                                       
}ARGBCTR_TypeDef;


/**
 * @name ARGB sample parameter.
 *   		
 */ 

///@{
extern ARGBCTR_TypeDef   ARGB0;

///@}


/**
 * @name ARGB sample function.
 *   		
 */ 

///@{
void API_ARGB_IRQHandler( ARGBCTR_TypeDef* sARGB);

void API_ARGB_Init(void );
void API_ARGB_UpdateTrigger( uint8_t ARGB_Mode);
void API_ARGB_main(void);


///@}



#endif


